#
# Example for building demo sample programs:
#
# 1. All sample demos:
#
#    make -f demo_ldap.mk demos
#
# 2. A single demo:
#
#    make -f demo_ldap.mk build EXE=demo OBJS="demo.o ..."
#    e.g. make -f demo_ldap.mk build EXE=samplesearch OBJS=samplesearch.o
#
# NOTE: 1. ORACLE_HOME must be either:
#		   . set in the user's environment
#		   . passed in on the command line
#		   . defined in a modified version of this makefile
#
#       2. If the target platform support shared libraries (e.g. Solaris)
#          look in the platform specific documentation for information
#          about environment variables that need to be properly
#          defined (e.g. LD_LIBRARY_PATH in Solaris).
#


include $(ORACLE_HOME)/ldap/lib/env_ldap.mk

I_SYM = -I
INCLUDE = -I $(ORACLE_HOME)/ldap/public $(ORACLE_HOME)/ldap/include \
          $(ORACOREPUBH) $(NLSRTLPUBH)

LDAPLIB=$(ORACLE_HOME)/ldap/lib/

#LDFLAGS= -L$(LIBHOME) -L$(LDAPLIB)
DEMO_MAKEFILE = demo_ldap.mk
 
DEMOS = samplesearch

.SUFFIXES: .o .c

demos: $(DEMOS)


$(DEMOS):
	$(MAKE) -f $(DEMO_MAKEFILE) build EXE=$@ OBJS=$@.o

.c.o:
	$(CC) $(CCFLAGS) -c $(INCLUDE) $<

build: $(OBJS)
	$(ECHODO) $(CC) $(LDFLAGS) -o $(EXE) $(OBJS) $(LLIBLDAPCLNT) \
        $(OTHER_LIBS) $(TTLIBS) `cat $(ORACLE_HOME)/lib/sysliblist`

clean:
	$(RM) -f $(DEMOS) *.o *.so

